"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.keyValueExtractionRegex = void 0;
exports.getTerragruntDependencyType = getTerragruntDependencyType;
exports.checkFileContainsDependency = checkFileContainsDependency;
const regex_1 = require("../../../util/regex");
exports.keyValueExtractionRegex = (0, regex_1.regEx)(/^\s*source\s+=\s+"(?<value>[^"]+)"\s*$/);
function getTerragruntDependencyType(value) {
    switch (value) {
        case 'terraform': {
            return 'terraform';
        }
        default: {
            return 'unknown';
        }
    }
}
function checkFileContainsDependency(content, checkList) {
    return checkList.some((check) => content.includes(check));
}
//# sourceMappingURL=util.js.map