"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.supportsLockFileMaintenance = exports.extractPackageFile = exports.updateArtifacts = void 0;
const bitbucket_tags_1 = require("../../datasource/bitbucket-tags");
const git_tags_1 = require("../../datasource/git-tags");
const gitea_tags_1 = require("../../datasource/gitea-tags");
const github_tags_1 = require("../../datasource/github-tags");
const gitlab_tags_1 = require("../../datasource/gitlab-tags");
const terraform_module_1 = require("../../datasource/terraform-module");
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.supportsLockFileMaintenance = true;
exports.url = 'https://terragrunt.gruntwork.io/docs';
exports.categories = ['iac', 'terraform'];
exports.defaultConfig = {
    commitMessageTopic: 'Terragrunt dependency {{depName}}',
    managerFilePatterns: ['/(^|/)terragrunt\\.hcl$/'],
};
exports.supportedDatasources = [
    git_tags_1.GitTagsDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    gitlab_tags_1.GitlabTagsDatasource.id,
    bitbucket_tags_1.BitbucketTagsDatasource.id,
    gitea_tags_1.GiteaTagsDatasource.id,
    terraform_module_1.TerraformModuleDatasource.id,
];
//# sourceMappingURL=index.js.map