"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkFileContainsDependency = checkFileContainsDependency;
exports.checkIfStringIsPath = checkIfStringIsPath;
exports.massageProviderLookupName = massageProviderLookupName;
exports.getLockedVersion = getLockedVersion;
exports.extractLocksForPackageFile = extractLocksForPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../../../util/regex");
const terraform_provider_1 = require("../../datasource/terraform-provider");
const util_1 = require("./lockfile/util");
function checkFileContainsDependency(content, checkList) {
    return checkList.some((check) => content.includes(check));
}
const pathStringRegex = (0, regex_1.regEx)(/(.|..)?(\/[^/])+/);
function checkIfStringIsPath(path) {
    const match = pathStringRegex.exec(path);
    return !!match;
}
function massageProviderLookupName(dep) {
    dep.packageName ??= dep.depName;
    // TODO #22198
    if (!dep.packageName.includes('/')) {
        dep.packageName = `hashicorp/${dep.packageName}`;
    }
    // handle cases like `Telmate/proxmox`
    // TODO #22198
    dep.packageName = dep.packageName.toLowerCase();
}
function getLockedVersion(dep, locks) {
    const depRegistryUrl = dep.registryUrls
        ? dep.registryUrls[0]
        : terraform_provider_1.TerraformProviderDatasource.defaultRegistryUrls[0];
    const foundLock = locks.find((lock) => lock.packageName === dep.packageName &&
        lock.registryUrl === depRegistryUrl);
    if (foundLock) {
        return foundLock.version;
    }
    return undefined;
}
async function extractLocksForPackageFile(fileName) {
    const locks = [];
    const lockFilePath = await (0, util_1.findLockFile)(fileName);
    if (lockFilePath) {
        const lockFileContent = await (0, util_1.readLockFile)(lockFilePath);
        if (lockFileContent) {
            const extractedLocks = (0, util_1.extractLocks)(lockFileContent);
            if (is_1.default.nonEmptyArray(extractedLocks)) {
                locks.push(...extractedLocks);
            }
        }
    }
    return locks;
}
//# sourceMappingURL=util.js.map