"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.supportsLockFileMaintenance = exports.extractPackageFile = exports.updateLockedDependency = exports.updateArtifacts = void 0;
const bitbucket_tags_1 = require("../../datasource/bitbucket-tags");
const docker_1 = require("../../datasource/docker");
const git_tags_1 = require("../../datasource/git-tags");
const github_releases_1 = require("../../datasource/github-releases");
const github_tags_1 = require("../../datasource/github-tags");
const helm_1 = require("../../datasource/helm");
const terraform_module_1 = require("../../datasource/terraform-module");
const terraform_provider_1 = require("../../datasource/terraform-provider");
var lockfile_1 = require("./lockfile");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return lockfile_1.updateArtifacts; } });
var update_locked_1 = require("./lockfile/update-locked");
Object.defineProperty(exports, "updateLockedDependency", { enumerable: true, get: function () { return update_locked_1.updateLockedDependency; } });
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.supportsLockFileMaintenance = true;
exports.url = 'https://developer.hashicorp.com/terraform/docs';
exports.categories = ['iac', 'terraform'];
exports.defaultConfig = {
    commitMessageTopic: 'Terraform {{depName}}',
    managerFilePatterns: ['/\\.tf$/'],
    pinDigests: false,
};
exports.supportedDatasources = [
    bitbucket_tags_1.BitbucketTagsDatasource.id,
    docker_1.DockerDatasource.id,
    git_tags_1.GitTagsDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    github_releases_1.GithubReleasesDatasource.id,
    helm_1.HelmDatasource.id,
    terraform_module_1.TerraformModuleDatasource.id,
    terraform_provider_1.TerraformProviderDatasource.id,
];
//# sourceMappingURL=index.js.map