"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformVersionExtractor = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const github_releases_1 = require("../../../../datasource/github-releases");
const hashicorp = tslib_1.__importStar(require("../../../../versioning/hashicorp"));
const base_1 = require("../../base");
class TerraformVersionExtractor extends base_1.DependencyExtractor {
    getCheckList() {
        return ['required_version'];
    }
    extract(hclRoot) {
        const terraformBlocks = hclRoot?.terraform;
        if (is_1.default.nullOrUndefined(terraformBlocks)) {
            return [];
        }
        const dependencies = [];
        for (const terraformBlock of terraformBlocks) {
            const requiredVersion = terraformBlock.required_version;
            if (is_1.default.nullOrUndefined(requiredVersion)) {
                continue;
            }
            dependencies.push(this.analyseTerraformVersion({
                currentValue: requiredVersion,
            }));
        }
        return dependencies;
    }
    analyseTerraformVersion(dep) {
        dep.depType = 'required_version';
        dep.datasource = github_releases_1.GithubReleasesDatasource.id;
        dep.depName = 'hashicorp/terraform';
        dep.extractVersion = 'v(?<version>.*)$';
        dep.versioning = hashicorp.id;
        return dep;
    }
}
exports.TerraformVersionExtractor = TerraformVersionExtractor;
//# sourceMappingURL=terraform-version.js.map