import type { ExtractConfig, PackageDependency } from '../../../types';
import { DependencyExtractor } from '../../base';
import type { TerraformDefinitionFile } from '../../hcl/types';
import type { ProviderLock } from '../../lockfile/types';
export declare class GenericDockerImageRefExtractor extends DependencyExtractor {
    getCheckList(): string[];
    extract(hclMap: TerraformDefinitionFile, _locks: ProviderLock[], config: ExtractConfig): PackageDependency[];
    private extractResources;
    /**
     * Recursively follow the path to find elements on the path.
     * If a path element is '*' the parentElement will be interpreted as a list
     * and each element will be followed
     * @param abstractDep dependency which will used as basis for adding attributes
     * @param parentElement element from which the next element will be extracted
     * @param leftPath path elements left to walk down
     */
    private walkPath;
}
