"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resourceExtractors = void 0;
const modules_1 = require("./extractors/others/modules");
const providers_1 = require("./extractors/others/providers");
const generic_docker_image_ref_1 = require("./extractors/resources/generic-docker-image-ref");
const helm_release_1 = require("./extractors/resources/helm-release");
const terraform_workspace_1 = require("./extractors/resources/terraform-workspace");
const required_provider_1 = require("./extractors/terraform-block/required-provider");
const terraform_version_1 = require("./extractors/terraform-block/terraform-version");
exports.resourceExtractors = [
    new helm_release_1.HelmReleaseExtractor(),
    new generic_docker_image_ref_1.GenericDockerImageRefExtractor(),
    new terraform_workspace_1.TerraformWorkspaceExtractor(),
    new required_provider_1.RequiredProviderExtractor(),
    new terraform_version_1.TerraformVersionExtractor(),
    new providers_1.ProvidersExtractor(),
    new modules_1.ModuleExtractor(),
];
//# sourceMappingURL=extractors.js.map