"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const extractors_1 = require("./extractors");
const hcl = tslib_1.__importStar(require("./hcl"));
const util_1 = require("./util");
async function extractPackageFile(content, packageFile, config) {
    logger_1.logger.trace({ content }, `terraform.extractPackageFile(${packageFile})`);
    const passedExtractors = [];
    for (const extractor of extractors_1.resourceExtractors) {
        if ((0, util_1.checkFileContainsDependency)(content, extractor.getCheckList())) {
            passedExtractors.push(extractor);
        }
    }
    if (!passedExtractors.length) {
        logger_1.logger.debug({ packageFile }, 'preflight content check has not found any relevant content');
        return null;
    }
    logger_1.logger.trace({ packageFile }, `preflight content check passed for extractors: [${passedExtractors
        .map((value) => value.constructor.name)
        .toString()}]`);
    const dependencies = [];
    const hclMap = await hcl.parseHCL(content, packageFile);
    if (is_1.default.nullOrUndefined(hclMap)) {
        logger_1.logger.debug({ packageFile }, 'failed to parse HCL file');
        return null;
    }
    const locks = await (0, util_1.extractLocksForPackageFile)(packageFile);
    for (const extractor of passedExtractors) {
        const deps = extractor.extract(hclMap, locks, config);
        dependencies.push(...deps);
    }
    dependencies.forEach((value) => delete value.managerData);
    return dependencies.length ? { deps: dependencies } : null;
}
//# sourceMappingURL=extract.js.map