"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProfileDefinition = exports.EventTrigger = exports.Profile = exports.ClusterProfile = exports.SveltosHelmSpec = exports.SveltosHelmSource = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const schema_1 = require("../flux/schema");
exports.SveltosHelmSource = zod_1.z.object({
    repositoryURL: zod_1.z.string(),
    repositoryName: zod_1.z.string(),
    chartName: zod_1.z.string(),
    chartVersion: zod_1.z.string(),
});
exports.SveltosHelmSpec = zod_1.z.object({
    helmCharts: (0, schema_utils_1.LooseArray)(exports.SveltosHelmSource).optional(),
});
exports.ClusterProfile = schema_1.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('config.projectsveltos.io/'),
    kind: zod_1.z.literal('ClusterProfile'),
    spec: exports.SveltosHelmSpec,
});
exports.Profile = schema_1.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('config.projectsveltos.io/'),
    kind: zod_1.z.literal('Profile'),
    spec: exports.SveltosHelmSpec,
});
exports.EventTrigger = schema_1.KubernetesResource.extend({
    apiVersion: zod_1.z.string().startsWith('lib.projectsveltos.io/'),
    kind: zod_1.z.literal('EventTrigger'),
    spec: exports.SveltosHelmSpec,
});
// Create a union schema for ProfileDefinition
exports.ProfileDefinition = zod_1.z.union([
    exports.Profile,
    exports.ClusterProfile,
    exports.EventTrigger,
]);
//# sourceMappingURL=schema.js.map