import { z } from 'zod';
export declare const SveltosHelmSource: z.ZodObject<{
    repositoryURL: z.ZodString;
    repositoryName: z.ZodString;
    chartName: z.ZodString;
    chartVersion: z.ZodString;
}, "strip", z.ZodTypeAny, {
    repositoryName: string;
    repositoryURL: string;
    chartName: string;
    chartVersion: string;
}, {
    repositoryName: string;
    repositoryURL: string;
    chartName: string;
    chartVersion: string;
}>;
export type SveltosHelmSource = z.infer<typeof SveltosHelmSource>;
export declare const SveltosHelmSpec: z.ZodObject<{
    helmCharts: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        repositoryName: string;
        repositoryURL: string;
        chartName: string;
        chartVersion: string;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    helmCharts?: {
        repositoryName: string;
        repositoryURL: string;
        chartName: string;
        chartVersion: string;
    }[] | undefined;
}, {
    helmCharts?: any[] | undefined;
}>;
export type SveltosHelmSpec = z.infer<typeof SveltosHelmSpec>;
export declare const ClusterProfile: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"ClusterProfile">;
    spec: z.ZodObject<{
        helmCharts: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    }, {
        helmCharts?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "ClusterProfile";
    spec: {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "ClusterProfile";
    spec: {
        helmCharts?: any[] | undefined;
    };
}>;
export declare const Profile: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"Profile">;
    spec: z.ZodObject<{
        helmCharts: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    }, {
        helmCharts?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Profile";
    spec: {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Profile";
    spec: {
        helmCharts?: any[] | undefined;
    };
}>;
export declare const EventTrigger: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"EventTrigger">;
    spec: z.ZodObject<{
        helmCharts: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    }, {
        helmCharts?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "EventTrigger";
    spec: {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "EventTrigger";
    spec: {
        helmCharts?: any[] | undefined;
    };
}>;
export declare const ProfileDefinition: z.ZodUnion<[z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"Profile">;
    spec: z.ZodObject<{
        helmCharts: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    }, {
        helmCharts?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Profile";
    spec: {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Profile";
    spec: {
        helmCharts?: any[] | undefined;
    };
}>, z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"ClusterProfile">;
    spec: z.ZodObject<{
        helmCharts: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    }, {
        helmCharts?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "ClusterProfile";
    spec: {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "ClusterProfile";
    spec: {
        helmCharts?: any[] | undefined;
    };
}>, z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"EventTrigger">;
    spec: z.ZodObject<{
        helmCharts: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    }, {
        helmCharts?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "EventTrigger";
    spec: {
        helmCharts?: {
            repositoryName: string;
            repositoryURL: string;
            chartName: string;
            chartVersion: string;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "EventTrigger";
    spec: {
        helmCharts?: any[] | undefined;
    };
}>]>;
export type ProfileDefinition = z.infer<typeof ProfileDefinition>;
