"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
exports.extractDefinition = extractDefinition;
const array_1 = require("../../../util/array");
const url_1 = require("../../../util/url");
const yaml_1 = require("../../../util/yaml");
const docker_1 = require("../../datasource/docker");
const helm_1 = require("../../datasource/helm");
const extract_1 = require("../dockerfile/extract");
const oci_1 = require("../helmv3/oci");
const schema_1 = require("./schema");
const util_1 = require("./util");
function extractPackageFile(content, packageFile, config) {
    const definitions = (0, yaml_1.parseYaml)(content, {
        customSchema: schema_1.ProfileDefinition,
        failureBehaviour: 'filter',
    });
    const deps = [];
    for (const definition of definitions) {
        const extractedDeps = extractDefinition(definition, config);
        deps.push(...extractedDeps);
    }
    return deps.length ? { deps } : null;
}
function extractDefinition(definition, config) {
    return processAppSpec(definition, config);
}
function processHelmCharts(source, registryAliases) {
    const dep = {
        depName: source.chartName,
        currentValue: source.chartVersion,
        datasource: helm_1.HelmDatasource.id,
    };
    if ((0, oci_1.isOCIRegistry)(source.repositoryURL)) {
        const image = (0, url_1.trimTrailingSlash)((0, oci_1.removeOCIPrefix)(source.repositoryURL));
        dep.datasource = docker_1.DockerDatasource.id;
        dep.packageName = (0, extract_1.getDep)(image, false, registryAliases).packageName;
    }
    else {
        dep.packageName = (0, util_1.removeRepositoryName)(source.repositoryName, source.chartName);
        dep.registryUrls = [source.repositoryURL];
        dep.datasource = helm_1.HelmDatasource.id;
    }
    return dep;
}
function processAppSpec(definition, config) {
    const deps = [];
    const depType = definition.kind;
    for (const source of (0, array_1.coerceArray)(definition.spec?.helmCharts)) {
        const dep = processHelmCharts(source, config?.registryAliases);
        if (dep) {
            dep.depType = depType;
            deps.push(dep);
        }
    }
    return deps;
}
//# sourceMappingURL=extract.js.map