"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const regex_1 = require("../../../util/regex");
const github_releases_1 = require("../../datasource/github-releases");
const semverVersioning = tslib_1.__importStar(require("../../versioning/semver"));
const scalafmtVersionRegex = (0, regex_1.regEx)('version *= *"?(?<version>\\d+\\.\\d+\\.\\d+)"?');
function extractPackageFile(content) {
    const regexResult = scalafmtVersionRegex.exec(content);
    const scalafmtVersion = regexResult?.groups?.version;
    if (!scalafmtVersion) {
        return null;
    }
    const scalafmtDependency = {
        datasource: github_releases_1.GithubReleasesDatasource.id,
        depName: 'scalafmt',
        packageName: 'scalameta/scalafmt',
        versioning: semverVersioning.id,
        currentValue: scalafmtVersion,
        extractVersion: '^v(?<version>\\S+)',
    };
    return {
        deps: [scalafmtDependency],
    };
}
//# sourceMappingURL=extract.js.map