"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeScalaVersion = normalizeScalaVersion;
exports.sortPackageFiles = sortPackageFiles;
const tslib_1 = require("tslib");
const regex_1 = require("../../../util/regex");
const versioning_1 = require("../../versioning");
const mavenVersioning = tslib_1.__importStar(require("../../versioning/maven"));
/*
  https://www.scala-sbt.org/release/docs/Cross-Build.html#Publishing+conventions
 */
function normalizeScalaVersion(str) {
    // istanbul ignore if
    if (!str) {
        return str;
    }
    const versioning = (0, versioning_1.get)(mavenVersioning.id);
    if (versioning.isVersion(str)) {
        // Do not normalize unstable versions
        if (!versioning.isStable(str)) {
            return str;
        }
        // Do not normalize versions prior to 2.10
        if (!versioning.isGreaterThan(str, '2.10.0')) {
            return str;
        }
    }
    const isScala3 = versioning.isGreaterThan(str, '3.0.0');
    if ((0, regex_1.regEx)(/^\d+\.\d+\.\d+$/).test(str)) {
        if (isScala3) {
            return str.replace((0, regex_1.regEx)(/^(\d+)\.(\d+)\.\d+$/), '$1');
        }
        else {
            return str.replace((0, regex_1.regEx)(/^(\d+)\.(\d+)\.\d+$/), '$1.$2');
        }
    }
    // istanbul ignore next
    return str;
}
function sortPackageFiles(packageFiles) {
    // process build.sbt first
    const sortedPackageFiles = [...packageFiles];
    const buildSbtIndex = sortedPackageFiles.findIndex((file) => file.endsWith('build.sbt'));
    if (buildSbtIndex !== -1) {
        const buildSbt = sortedPackageFiles.splice(buildSbtIndex, 1)[0];
        sortedPackageFiles.unshift(buildSbt);
    }
    return sortedPackageFiles;
}
//# sourceMappingURL=util.js.map