"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pythonRuntimeRegex = void 0;
exports.extractPackageFile = extractPackageFile;
const regex_1 = require("../../../util/regex");
const docker_1 = require("../../datasource/docker");
exports.pythonRuntimeRegex = (0, regex_1.regEx)('^python-(?<version>\\d+\\.\\d+\\.\\d+)$');
function extractPackageFile(content) {
    const regexResult = exports.pythonRuntimeRegex.exec(content);
    const runtimeVersion = regexResult?.groups?.version;
    if (runtimeVersion) {
        const dep = {
            depName: 'python',
            currentValue: runtimeVersion,
            datasource: docker_1.DockerDatasource.id,
        };
        return { deps: [dep] };
    }
    return null;
}
//# sourceMappingURL=extract.js.map