"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.url = exports.extractPackageFile = void 0;
const app_strings_1 = require("../../../config/app-strings");
const gitea_tags_1 = require("../../datasource/gitea-tags");
const github_tags_1 = require("../../datasource/github-tags");
const gitlab_tags_1 = require("../../datasource/gitlab-tags");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = '../../../config-presets.md';
exports.defaultConfig = {
    managerFilePatterns: app_strings_1.configFileNames.filter((name) => name !== 'package.json'),
};
exports.supportedDatasources = [
    github_tags_1.GithubTagsDatasource.id,
    gitlab_tags_1.GitlabTagsDatasource.id,
    gitea_tags_1.GiteaTagsDatasource.id,
];
//# sourceMappingURL=index.js.map