"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parsePubspec = parsePubspec;
exports.parsePubspecLock = parsePubspecLock;
const logger_1 = require("../../../logger");
const schema_1 = require("./schema");
function parsePubspec(fileName, fileContent) {
    const res = schema_1.PubspecYaml.safeParse(fileContent);
    if (res.success) {
        return res.data;
    }
    else {
        logger_1.logger.debug({ err: res.error, fileName }, 'Error parsing pubspec.');
    }
    return null;
}
function parsePubspecLock(fileName, fileContent) {
    const res = schema_1.PubspecLockYaml.safeParse(fileContent);
    if (res.success) {
        return res.data;
    }
    else {
        logger_1.logger.debug({ err: res.error, fileName }, 'Error parsing pubspec lockfile.');
    }
    return null;
}
//# sourceMappingURL=utils.js.map