"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const dart_1 = require("../../datasource/dart");
const dart_version_1 = require("../../datasource/dart-version");
const flutter_version_1 = require("../../datasource/flutter-version");
const utils_1 = require("./utils");
function extractFromSection(pubspec, sectionKey) {
    const sectionContent = pubspec[sectionKey];
    if (!sectionContent) {
        return [];
    }
    const skippedPackages = [
        'flutter_driver',
        'flutter_localizations',
        'flutter_test',
        'flutter_web_plugins',
        'meta',
    ];
    const deps = [];
    for (const depName of Object.keys(sectionContent)) {
        if (skippedPackages.includes(depName)) {
            continue;
        }
        let currentValue = sectionContent[depName];
        let skipReason;
        let registryUrls;
        if (!is_1.default.string(currentValue)) {
            const version = currentValue.version;
            const path = currentValue.path;
            const hosted = currentValue.hosted;
            if (is_1.default.string(hosted)) {
                registryUrls = [hosted];
            }
            else if (is_1.default.string(hosted?.url)) {
                registryUrls = [hosted.url];
            }
            if (version) {
                currentValue = version;
            }
            else if (path) {
                currentValue = '';
                skipReason = 'path-dependency';
            }
            else {
                currentValue = '';
            }
        }
        deps.push({
            depName,
            depType: sectionKey,
            currentValue,
            datasource: dart_1.DartDatasource.id,
            ...(registryUrls && { registryUrls }),
            skipReason,
        });
    }
    return deps;
}
function extractDart(pubspec) {
    return [
        {
            depName: 'dart',
            currentValue: pubspec.environment.sdk,
            datasource: dart_version_1.DartVersionDatasource.id,
        },
    ];
}
function extractFlutter(pubspec) {
    const currentValue = pubspec.environment.flutter;
    if (!currentValue) {
        return [];
    }
    return [
        {
            depName: 'flutter',
            currentValue,
            datasource: flutter_version_1.FlutterVersionDatasource.id,
        },
    ];
}
function extractPackageFile(content, packageFile) {
    const pubspec = (0, utils_1.parsePubspec)(packageFile, content);
    if (!pubspec) {
        return null;
    }
    return {
        deps: [
            ...extractFromSection(pubspec, 'dependencies'),
            ...extractFromSection(pubspec, 'dev_dependencies'),
            ...extractDart(pubspec),
            ...extractFlutter(pubspec),
        ],
    };
}
//# sourceMappingURL=extract.js.map