"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateLockedDependency = updateLockedDependency;
const logger_1 = require("../../../logger");
const result_1 = require("../../../util/result");
const schema_1 = require("./schema");
function updateLockedDependency(config) {
    const { depName, currentVersion, newVersion, lockFile, lockFileContent } = config;
    logger_1.logger.debug(`poetry.updateLockedDependency: ${depName}@${currentVersion} -> ${newVersion} [${lockFile}]`);
    const LockedVersionSchema = schema_1.Lockfile.transform(({ lock }) => lock[depName]);
    return result_1.Result.parse(lockFileContent, LockedVersionSchema)
        .transform((lockedVersion) => lockedVersion === newVersion
        ? { status: 'already-updated' }
        : { status: 'unsupported' })
        .unwrapOr({ status: 'unsupported' });
}
//# sourceMappingURL=update-locked.js.map