import { z } from 'zod';
import type { PackageDependency } from '../types';
export type Channels = z.infer<typeof Channel>[];
declare const Channel: z.ZodUnion<[z.ZodString, z.ZodObject<{
    channel: z.ZodString;
    priority: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    priority: number;
    channel: string;
}, {
    priority: number;
    channel: string;
}>]>;
export interface PixiPackageDependency extends PackageDependency {
    channel?: string;
    channels?: Channels;
}
/**
 * `$` of `pixi.toml` or `$.tool.pixi` of `pyproject.toml`
 */
export declare const PixiConfigSchema: z.ZodIntersection<z.ZodIntersection<z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    workspace: z.ZodObject<{
        channels: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodObject<{
            channel: z.ZodString;
            priority: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            priority: number;
            channel: string;
        }, {
            priority: number;
            channel: string;
        }>]>, "many">>;
        'requires-pixi': z.ZodOptional<z.ZodString>;
        'channel-priority': z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"strict">, z.ZodLiteral<"disabled">]>>;
    }, "strip", z.ZodTypeAny, {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    }, {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    workspace: {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    };
}, {
    workspace: {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    };
}>, {
    project: {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    };
}, {
    workspace: {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    };
}>, z.ZodObject<{
    project: z.ZodObject<{
        channels: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodObject<{
            channel: z.ZodString;
            priority: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            priority: number;
            channel: string;
        }, {
            priority: number;
            channel: string;
        }>]>, "many">>;
        'requires-pixi': z.ZodOptional<z.ZodString>;
        'channel-priority': z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"strict">, z.ZodLiteral<"disabled">]>>;
    }, "strip", z.ZodTypeAny, {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    }, {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    project: {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    };
}, {
    project: {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    };
}>]>, z.ZodObject<{
    feature: z.ZodDefault<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
    } & {
        pypi: PixiPackageDependency[];
        conda: PixiPackageDependency[];
    }>, Record<string, any>>, {
        conda: PixiPackageDependency[];
        pypi: PixiPackageDependency[];
    }, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    feature: {
        conda: PixiPackageDependency[];
        pypi: PixiPackageDependency[];
    };
}, {
    feature?: Record<string, any> | undefined;
}>>, z.ZodEffects<z.ZodObject<{
    dependencies: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        currentValue: string;
        versioning: string;
        datasource: string;
        channel: string | undefined;
    }>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>>;
    'pypi-dependencies': z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        currentValue: string;
        versioning: string;
        datasource: string;
    } | {
        currentValue: string | undefined;
        packageName: string;
        datasource: string;
        versioning: string;
        skipStage: "extract";
        skipReason: "unspecified-version";
    } | {
        currentValue: string;
        packageName: string;
        datasource: string;
        versioning: string;
        skipStage?: undefined;
        skipReason?: undefined;
    }>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>>;
    target: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        dependencies: PackageDependency<Record<string, any>>[];
        'pypi-dependencies': PackageDependency<Record<string, any>>[];
    }>, Record<string, any>>, {
        pypi: PixiPackageDependency[];
        conda: PixiPackageDependency[];
    }, Record<string, any>>>>;
}, "strip", z.ZodTypeAny, {
    target: {
        pypi: PixiPackageDependency[];
        conda: PixiPackageDependency[];
    };
    dependencies: PackageDependency<Record<string, any>>[];
    'pypi-dependencies': PackageDependency<Record<string, any>>[];
}, {
    target?: Record<string, any> | undefined;
    dependencies?: Record<string, any> | undefined;
    'pypi-dependencies'?: Record<string, any> | undefined;
}>, {
    pypi: PixiPackageDependency[];
    conda: PixiPackageDependency[];
}, {
    target?: Record<string, any> | undefined;
    dependencies?: Record<string, any> | undefined;
    'pypi-dependencies'?: Record<string, any> | undefined;
}>>;
export type PixiConfig = z.infer<typeof PixiConfigSchema>;
export declare const PixiToml: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodIntersection<z.ZodIntersection<z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    workspace: z.ZodObject<{
        channels: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodObject<{
            channel: z.ZodString;
            priority: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            priority: number;
            channel: string;
        }, {
            priority: number;
            channel: string;
        }>]>, "many">>;
        'requires-pixi': z.ZodOptional<z.ZodString>;
        'channel-priority': z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"strict">, z.ZodLiteral<"disabled">]>>;
    }, "strip", z.ZodTypeAny, {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    }, {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    workspace: {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    };
}, {
    workspace: {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    };
}>, {
    project: {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    };
}, {
    workspace: {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    };
}>, z.ZodObject<{
    project: z.ZodObject<{
        channels: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodObject<{
            channel: z.ZodString;
            priority: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            priority: number;
            channel: string;
        }, {
            priority: number;
            channel: string;
        }>]>, "many">>;
        'requires-pixi': z.ZodOptional<z.ZodString>;
        'channel-priority': z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"strict">, z.ZodLiteral<"disabled">]>>;
    }, "strip", z.ZodTypeAny, {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    }, {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    project: {
        channels: (string | {
            priority: number;
            channel: string;
        })[];
        'channel-priority': "disabled" | "strict";
        'requires-pixi'?: string | undefined;
    };
}, {
    project: {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
        'requires-pixi'?: string | undefined;
        'channel-priority'?: "disabled" | "strict" | undefined;
    };
}>]>, z.ZodObject<{
    feature: z.ZodDefault<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        channels?: (string | {
            priority: number;
            channel: string;
        })[] | undefined;
    } & {
        pypi: PixiPackageDependency[];
        conda: PixiPackageDependency[];
    }>, Record<string, any>>, {
        conda: PixiPackageDependency[];
        pypi: PixiPackageDependency[];
    }, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    feature: {
        conda: PixiPackageDependency[];
        pypi: PixiPackageDependency[];
    };
}, {
    feature?: Record<string, any> | undefined;
}>>, z.ZodEffects<z.ZodObject<{
    dependencies: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        currentValue: string;
        versioning: string;
        datasource: string;
        channel: string | undefined;
    }>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>>;
    'pypi-dependencies': z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        currentValue: string;
        versioning: string;
        datasource: string;
    } | {
        currentValue: string | undefined;
        packageName: string;
        datasource: string;
        versioning: string;
        skipStage: "extract";
        skipReason: "unspecified-version";
    } | {
        currentValue: string;
        packageName: string;
        datasource: string;
        versioning: string;
        skipStage?: undefined;
        skipReason?: undefined;
    }>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>>;
    target: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        dependencies: PackageDependency<Record<string, any>>[];
        'pypi-dependencies': PackageDependency<Record<string, any>>[];
    }>, Record<string, any>>, {
        pypi: PixiPackageDependency[];
        conda: PixiPackageDependency[];
    }, Record<string, any>>>>;
}, "strip", z.ZodTypeAny, {
    target: {
        pypi: PixiPackageDependency[];
        conda: PixiPackageDependency[];
    };
    dependencies: PackageDependency<Record<string, any>>[];
    'pypi-dependencies': PackageDependency<Record<string, any>>[];
}, {
    target?: Record<string, any> | undefined;
    dependencies?: Record<string, any> | undefined;
    'pypi-dependencies'?: Record<string, any> | undefined;
}>, {
    pypi: PixiPackageDependency[];
    conda: PixiPackageDependency[];
}, {
    target?: Record<string, any> | undefined;
    dependencies?: Record<string, any> | undefined;
    'pypi-dependencies'?: Record<string, any> | undefined;
}>>>;
export declare const LockfileYaml: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodObject<{
    version: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    version: number;
}, {
    version: number;
}>>;
export {};
