"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = exports.updateArtifacts = void 0;
const git_tags_1 = require("../../datasource/git-tags");
const pypi_1 = require("../../datasource/pypi");
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'pip Requirements';
exports.url = 'https://pip.pypa.io/en/stable/reference/requirements-file-format';
exports.categories = ['python'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)[\\w-]*requirements([-.]\\w+)?\\.(txt|pip)$/'],
};
exports.supportedDatasources = [pypi_1.PypiDatasource.id, git_tags_1.GitTagsDatasource.id];
//# sourceMappingURL=index.js.map