import type { ExecOptions, ExtraEnv, ToolConstraint } from '../../../util/exec/types';
import type { PackageFileContent, UpdateArtifactsConfig } from '../types';
import type { CommandType, PipCompileArgs, SupportedManagers } from './types';
export declare function getPythonVersionConstraint(config: UpdateArtifactsConfig, extractedPythonVersion: string | undefined): string | undefined | null;
export declare function getPipToolsVersionConstraint(config: UpdateArtifactsConfig): string;
export declare function getUvVersionConstraint(config: UpdateArtifactsConfig): string;
export declare function getToolVersionConstraint(config: UpdateArtifactsConfig, commandType: CommandType): ToolConstraint;
export declare function getExecOptions(config: UpdateArtifactsConfig, commandType: CommandType, cwd: string, extraEnv: ExtraEnv<string>, extractedPythonVersion: string | undefined): Promise<ExecOptions>;
export declare const constraintLineRegex: RegExp;
export declare const disallowedPipOptions: string[];
export declare const optionsWithArguments: string[];
export declare const allowedOptions: Record<CommandType, string[]>;
export declare function extractHeaderCommand(content: string, fileName: string): PipCompileArgs;
export declare function extractPythonVersion(content: string, fileName: string): string | undefined;
export declare function getRegistryCredVarsFromPackageFiles(packageFiles: PackageFileContent[]): ExtraEnv<string>;
export declare function matchManager(filename: string): SupportedManagers | 'unknown';
