"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
const schema_1 = require("./schema");
// Adapted regex from the Python reference implementation: https://packaging.python.org/en/latest/specifications/inline-script-metadata/#reference-implementation
const regex = (0, regex_1.regEx)(/^# \/\/\/ (?<type>[a-zA-Z0-9-]+)$\s(?<content>(^#(| .*)$\s)+)^# \/\/\/$/, 'm');
function extractPackageFile(content, packageFile) {
    const match = regex.exec(content);
    const matchedContent = match?.groups?.content;
    if (!matchedContent) {
        return null;
    }
    // Adapted code from the Python reference implementation: https://packaging.python.org/en/latest/specifications/inline-script-metadata/#reference-implementation
    const parsedToml = matchedContent
        .split(regex_1.newlineRegex)
        .map((line) => line.substring(line.startsWith('# ') ? 2 : 1))
        .join('\n');
    const { data: res, error } = schema_1.Pep723Schema.safeParse(parsedToml);
    if (error) {
        logger_1.logger.debug({ packageFile, error }, `Error parsing PEP 723 inline script metadata`);
        return null;
    }
    return res.deps.length ? res : null;
}
//# sourceMappingURL=extract.js.map