import type { PackageDependency } from '../types';
import type { PyProject } from './schema';
import type { Pep508ParseResult } from './types';
export declare const depTypes: {
    dependencies: string;
    optionalDependencies: string;
    dependencyGroups: string;
    pdmDevDependencies: string;
    uvDevDependencies: string;
    uvSources: string;
    buildSystemRequires: string;
};
export declare function parsePEP508(value: string | null | undefined): Pep508ParseResult | null;
export declare function pep508ToPackageDependency(depType: string, value: string): PackageDependency | null;
export declare function parseDependencyGroupRecord(depType: string, records: Record<string, string[]> | null | undefined): PackageDependency[];
export declare function parseDependencyList(depType: string, list: string[] | null | undefined): PackageDependency[];
export declare function parsePyProject(packageFile: string, content: string): PyProject | null;
