"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bumpPackageVersion = bumpPackageVersion;
const pep440_1 = require("@renovatebot/pep440");
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
function bumpPackageVersion(content, currentValue, bumpVersion) {
    logger_1.logger.debug({ bumpVersion, currentValue }, 'Checking if we should bump pyproject.toml version');
    let bumpedContent = content;
    try {
        const newProjectVersion = (0, pep440_1.inc)(currentValue, bumpVersion);
        if (!newProjectVersion) {
            throw new Error('pep440 inc failed');
        }
        logger_1.logger.debug(`newProjectVersion: ${newProjectVersion}`);
        bumpedContent = content.replace((0, regex_1.regEx)(`^(?<version>version[ \\t]*=[ \\t]*['"])[^'"]*`, 'm'), `$<version>${newProjectVersion}`);
        if (bumpedContent === content) {
            logger_1.logger.debug('Version was already bumped');
        }
        else {
            logger_1.logger.debug('Bumped pyproject.toml version');
        }
    }
    catch {
        logger_1.logger.warn({
            content,
            currentValue,
            bumpVersion,
            manager: 'pep621',
        }, 'Failed to bumpVersion');
    }
    return { bumpedContent };
}
//# sourceMappingURL=update.js.map