"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const python_version_1 = require("../../datasource/python-version");
const pep440 = tslib_1.__importStar(require("../../versioning/pep440"));
const processors_1 = require("./processors");
const utils_1 = require("./utils");
async function extractPackageFile(content, packageFile, _config) {
    logger_1.logger.trace(`pep621.extractPackageFile(${packageFile})`);
    const deps = [];
    const def = (0, utils_1.parsePyProject)(packageFile, content);
    if (is_1.default.nullOrUndefined(def)) {
        return null;
    }
    const packageFileVersion = def.project?.version;
    const pythonConstraint = def.project?.['requires-python'];
    let extractedConstraints;
    if (is_1.default.nonEmptyString(pythonConstraint)) {
        extractedConstraints = {
            extractedConstraints: { python: pythonConstraint },
        };
        deps.push({
            packageName: 'python',
            depType: 'requires-python',
            currentValue: pythonConstraint,
            commitMessageTopic: 'Python',
            datasource: python_version_1.PythonVersionDatasource.id,
            versioning: pep440.id,
        });
    }
    else {
        extractedConstraints = {};
    }
    // pyProject standard definitions
    deps.push(...(0, utils_1.parseDependencyList)(utils_1.depTypes.dependencies, def.project?.dependencies));
    deps.push(...(0, utils_1.parseDependencyGroupRecord)(utils_1.depTypes.dependencyGroups, def['dependency-groups']));
    deps.push(...(0, utils_1.parseDependencyGroupRecord)(utils_1.depTypes.optionalDependencies, def.project?.['optional-dependencies']));
    deps.push(...(0, utils_1.parseDependencyList)(utils_1.depTypes.buildSystemRequires, def['build-system']?.requires));
    // process specific tool sets
    let processedDeps = deps;
    for (const processor of processors_1.processors) {
        processedDeps = processor.process(def, processedDeps);
        processedDeps = await processor.extractLockedVersions(def, processedDeps, packageFile);
    }
    return processedDeps.length
        ? { ...extractedConstraints, deps: processedDeps, packageFileVersion }
        : null;
}
//# sourceMappingURL=extract.js.map