"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateArtifacts = updateArtifacts;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const fs_1 = require("../../../util/fs");
const processors_1 = require("./processors");
const utils_1 = require("./utils");
async function updateArtifacts(updateArtifact) {
    const { packageFileName, newPackageFileContent } = updateArtifact;
    await (0, fs_1.writeLocalFile)(packageFileName, newPackageFileContent);
    const project = (0, utils_1.parsePyProject)(packageFileName, newPackageFileContent);
    if (is_1.default.nullOrUndefined(project)) {
        return [
            {
                artifactError: {
                    stderr: 'Failed to parse new package file content',
                },
            },
        ];
    }
    // process specific tool sets
    const result = [];
    for (const processor of processors_1.processors) {
        const artifactUpdates = await processor.updateArtifacts(updateArtifact, project);
        if (is_1.default.array(artifactUpdates)) {
            result.push(...artifactUpdates);
        }
    }
    return result.length > 0 ? result : null;
}
//# sourceMappingURL=artifacts.js.map