import type { XmlElement, XmlNodeBase } from 'xmldoc';
import { XmlDocument } from 'xmldoc';
import { GlobalJson } from './schema';
import type { NugetPackageDependency, Registry } from './types';
export declare function readFileAsXmlDocument(file: string): Promise<XmlDocument | undefined>;
/**
 * The default `nuget.org` named registry.
 * @returns the default registry for NuGet
 */
export declare function getDefaultRegistries(): Registry[];
export declare function getConfiguredRegistries(packageFile: string): Promise<Registry[] | undefined>;
export declare function isXmlElement(child: XmlNodeBase): child is XmlElement;
export declare function findVersion(parsedXml: XmlDocument): XmlElement | null;
export declare function applyRegistries(dep: NugetPackageDependency, registries: Registry[] | undefined): NugetPackageDependency;
export declare function findGlobalJson(packageFile: string): Promise<GlobalJson | null>;
