import { z } from 'zod';
/**
 * The roll-forward policy to use when selecting an SDK version, either as a fallback when a specific SDK version is missing or as a directive to use a later version. A version must be specified with a rollForward value, unless you're setting it to latestMajor. The default roll forward behavior is determined by the matching rules.
 *
 * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#rollforward
 */
declare const RollForwardSchema: z.ZodEnum<["patch", "feature", "minor", "major", "latestPatch", "latestFeature", "latestMinor", "latestMajor", "disable"]>;
export type RollForward = z.infer<typeof RollForwardSchema>;
/**
 * global.json schema
 *
 * https://learn.microsoft.com/en-us/dotnet/core/tools/global-json#allowprerelease
 */
export declare const GlobalJsonSchema: z.ZodObject<{
    /**
     * Specifies information about the .NET SDK to select.
     */
    sdk: z.ZodOptional<z.ZodObject<{
        /**
         * The version of the .NET SDK to use.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#version
         */
        version: z.ZodOptional<z.ZodString>;
        /**
         * The roll-forward policy to use when selecting an SDK version, either as a fallback when a specific SDK version is missing or as a directive to use a later version. A version must be specified with a rollForward value, unless you're setting it to latestMajor. The default roll forward behavior is determined by the matching rules.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#rollforward
         */
        rollForward: z.ZodOptional<z.ZodEnum<["patch", "feature", "minor", "major", "latestPatch", "latestFeature", "latestMinor", "latestMajor", "disable"]>>;
        /**
         * Indicates whether the SDK resolver should consider prerelease versions when selecting the SDK version to use.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#allowprerelease
         */
        allowPrerelease: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    }, {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    }>>;
    /**
     * Lets you control the project SDK version in one place rather than in each individual project. For more information, see How project SDKs are resolved.
     *
     * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#msbuild-sdks
     */
    'msbuild-sdks': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    sdk?: {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    } | undefined;
    'msbuild-sdks'?: Record<string, string> | undefined;
}, {
    sdk?: {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    } | undefined;
    'msbuild-sdks'?: Record<string, string> | undefined;
}>;
export declare const GlobalJson: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodObject<{
    /**
     * Specifies information about the .NET SDK to select.
     */
    sdk: z.ZodOptional<z.ZodObject<{
        /**
         * The version of the .NET SDK to use.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#version
         */
        version: z.ZodOptional<z.ZodString>;
        /**
         * The roll-forward policy to use when selecting an SDK version, either as a fallback when a specific SDK version is missing or as a directive to use a later version. A version must be specified with a rollForward value, unless you're setting it to latestMajor. The default roll forward behavior is determined by the matching rules.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#rollforward
         */
        rollForward: z.ZodOptional<z.ZodEnum<["patch", "feature", "minor", "major", "latestPatch", "latestFeature", "latestMinor", "latestMajor", "disable"]>>;
        /**
         * Indicates whether the SDK resolver should consider prerelease versions when selecting the SDK version to use.
         *
         * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#allowprerelease
         */
        allowPrerelease: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    }, {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    }>>;
    /**
     * Lets you control the project SDK version in one place rather than in each individual project. For more information, see How project SDKs are resolved.
     *
     * https://learn.microsoft.com/de-de/dotnet/core/tools/global-json#msbuild-sdks
     */
    'msbuild-sdks': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    sdk?: {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    } | undefined;
    'msbuild-sdks'?: Record<string, string> | undefined;
}, {
    sdk?: {
        version?: string | undefined;
        rollForward?: "major" | "minor" | "patch" | "feature" | "latestPatch" | "latestFeature" | "latestMinor" | "latestMajor" | "disable" | undefined;
        allowPrerelease?: boolean | undefined;
    } | undefined;
    'msbuild-sdks'?: Record<string, string> | undefined;
}>>;
export type GlobalJson = z.infer<typeof GlobalJson>;
export {};
