"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractMsbuildGlobalManifest = extractMsbuildGlobalManifest;
const logger_1 = require("../../../../logger");
const dotnet_version_1 = require("../../../datasource/dotnet-version");
const nuget_1 = require("../../../datasource/nuget");
const schema_1 = require("../schema");
const util_1 = require("../util");
function extractMsbuildGlobalManifest(content, packageFile, registries) {
    const deps = [];
    let manifest;
    let extractedConstraints;
    try {
        manifest = schema_1.GlobalJson.parse(content);
    }
    catch {
        logger_1.logger.debug({ packageFile }, `Invalid JSON`);
        return null;
    }
    if (!manifest['msbuild-sdks'] && !manifest.sdk?.version) {
        logger_1.logger.debug({ packageFile }, 'This global.json is not a Nuget file');
        return null;
    }
    if (manifest.sdk?.version) {
        deps.push({
            depType: 'dotnet-sdk',
            depName: 'dotnet-sdk',
            currentValue: manifest.sdk?.version,
            datasource: dotnet_version_1.DotnetVersionDatasource.id,
        });
        extractedConstraints = { 'dotnet-sdk': manifest.sdk?.version };
    }
    if (manifest['msbuild-sdks']) {
        for (const depName of Object.keys(manifest['msbuild-sdks'])) {
            const currentValue = manifest['msbuild-sdks'][depName];
            const dep = {
                depType: 'msbuild-sdk',
                depName,
                currentValue,
                datasource: nuget_1.NugetDatasource.id,
            };
            (0, util_1.applyRegistries)(dep, registries);
            deps.push(dep);
        }
    }
    return { deps, ...(extractedConstraints && { extractedConstraints }) };
}
//# sourceMappingURL=global-manifest.js.map