"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseEntry = parseEntry;
exports.getYarn1LockedDependencies = getYarn1LockedDependencies;
exports.getYarn2LockedDependencies = getYarn2LockedDependencies;
exports.getLockedDependencies = getLockedDependencies;
const logger_1 = require("../../../../../../logger");
function parseEntry(depNameConstraint) {
    let entryName;
    let constraint;
    const split = depNameConstraint.split('@');
    if (split.length === 2) {
        [entryName, constraint] = split;
    }
    else if (split.length === 3) {
        entryName = '@' + split[1];
        constraint = split[2];
    }
    else {
        logger_1.logger.debug({ depNameConstraint }, 'Unexpected depNameConstraint');
        return null;
    }
    return { entryName, constraint };
}
function getYarn1LockedDependencies(yarnLock, depName, currentVersion) {
    const res = [];
    try {
        for (const [depNameConstraint, entry] of Object.entries(yarnLock)) {
            const parsed = parseEntry(depNameConstraint);
            // istanbul ignore if
            if (!parsed) {
                continue;
            }
            const { entryName, constraint } = parsed;
            if (entryName === depName && entry?.version === currentVersion) {
                res.push({ entry, depNameConstraint, depName, constraint });
            }
        }
    }
    catch (err) /* istanbul ignore next */ {
        logger_1.logger.warn({ err }, 'getLockedDependencies() error');
    }
    return res;
}
function getYarn2LockedDependencies(yarnLock, depName, currentVersion) {
    const res = [];
    try {
        for (const [fullConstraint, entry] of Object.entries(yarnLock)) {
            if (fullConstraint === '__metadata') {
                continue;
            }
            for (const subConstraint of fullConstraint.split(', ')) {
                const depNameConstraint = subConstraint;
                const parsed = parseEntry(depNameConstraint);
                // istanbul ignore if
                if (!parsed) {
                    continue;
                }
                const { entryName } = parsed;
                const constraint = parsed.constraint.replace(/^npm:/, '');
                if (entryName === depName && entry?.version === currentVersion) {
                    res.push({ entry, depNameConstraint, depName, constraint });
                }
            }
        }
    }
    catch (err) /* istanbul ignore next */ {
        logger_1.logger.warn({ err }, 'getLockedDependencies() error');
    }
    return res;
}
// Finds matching dependencies withing a package lock file of sub-entry
function getLockedDependencies(yarnLock, depName, currentVersion) {
    if ('__metadata' in yarnLock) {
        return getYarn2LockedDependencies(yarnLock, depName, currentVersion);
    }
    return getYarn1LockedDependencies(yarnLock, depName, currentVersion);
}
//# sourceMappingURL=get-locked.js.map