"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNewGitValue = getNewGitValue;
exports.getNewNpmAliasValue = getNewNpmAliasValue;
const logger_1 = require("../../../../../logger");
function getNewGitValue(upgrade) {
    if (!upgrade.currentRawValue) {
        return null;
    }
    if (upgrade.currentDigest) {
        logger_1.logger.debug('Updating git digest');
        return upgrade.currentRawValue.replace(upgrade.currentDigest, 
        // TODO #22198
        upgrade.newDigest.substring(0, upgrade.currentDigest.length));
    }
    else {
        logger_1.logger.debug('Updating git version tag');
        return upgrade.currentRawValue.replace(upgrade.currentValue, upgrade.newValue);
    }
}
function getNewNpmAliasValue(value, upgrade) {
    if (!upgrade.npmPackageAlias) {
        return null;
    }
    return `npm:${upgrade.packageName}@${value}`;
}
//# sourceMappingURL=common.js.map