"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRangeStrategy = getRangeStrategy;
const semver_utils_1 = require("semver-utils");
const logger_1 = require("../../../logger");
function getRangeStrategy(config) {
    const { depType, currentValue, rangeStrategy } = config;
    // TODO #22198
    const isComplexRange = (0, semver_utils_1.parseRange)(currentValue).length > 1;
    if (rangeStrategy === 'bump' && isComplexRange) {
        logger_1.logger.debug({ currentValue }, 'Replacing bump strategy for complex range with widen');
        return 'widen';
    }
    if (rangeStrategy !== 'auto') {
        return rangeStrategy;
    }
    if (depType === 'peerDependencies') {
        // Widen peer dependencies
        logger_1.logger.debug('Widening peer dependencies');
        return 'widen';
    }
    if (isComplexRange) {
        return 'widen';
    }
    return 'update-lockfile';
}
//# sourceMappingURL=range.js.map