"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadConfigFromLegacyYarnrc = loadConfigFromLegacyYarnrc;
exports.loadConfigFromYarnrcYml = loadConfigFromYarnrcYml;
exports.resolveRegistryUrl = resolveRegistryUrl;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const zod_1 = require("zod");
const logger_1 = require("../../../../logger");
const regex_1 = require("../../../../util/regex");
const result_1 = require("../../../../util/result");
const schema_utils_1 = require("../../../../util/schema-utils");
const YarnrcYmlSchema = schema_utils_1.Yaml.pipe(zod_1.z.object({
    npmRegistryServer: zod_1.z.string().optional(),
    npmScopes: zod_1.z
        .record(zod_1.z.object({
        npmRegistryServer: zod_1.z.string().optional(),
    }))
        .optional(),
}));
const registryRegEx = (0, regex_1.regEx)(/^"?(@(?<scope>[^:]+):)?registry"? "?(?<registryUrl>[^"]+)"?$/gm);
function loadConfigFromLegacyYarnrc(legacyYarnrc) {
    const registryMatches = [...legacyYarnrc.matchAll(registryRegEx)]
        .map((m) => m.groups)
        .filter(is_1.default.truthy);
    const yarnConfig = {};
    for (const registryMatch of registryMatches) {
        if (registryMatch.scope) {
            yarnConfig.npmScopes ??= {};
            yarnConfig.npmScopes[registryMatch.scope] ??= {};
            yarnConfig.npmScopes[registryMatch.scope].npmRegistryServer =
                registryMatch.registryUrl;
        }
        else {
            yarnConfig.npmRegistryServer = registryMatch.registryUrl;
        }
    }
    return yarnConfig;
}
function loadConfigFromYarnrcYml(yarnrcYml) {
    return result_1.Result.parse(yarnrcYml, YarnrcYmlSchema)
        .onError((err) => {
        logger_1.logger.warn({ yarnrcYml, err }, `Failed to load yarnrc file`);
    })
        .unwrapOrNull();
}
function resolveRegistryUrl(packageName, yarnConfig) {
    if (yarnConfig.npmScopes) {
        for (const scope in yarnConfig.npmScopes) {
            if (packageName.startsWith(`@${scope}/`)) {
                return yarnConfig.npmScopes[scope].npmRegistryServer ?? null;
            }
        }
    }
    if (yarnConfig.npmRegistryServer) {
        return yarnConfig.npmRegistryServer;
    }
    return null;
}
//# sourceMappingURL=yarnrc.js.map