"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.detectMonorepos = detectMonorepos;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../../../logger");
const fs_1 = require("../../../../../util/fs");
const pnpm_1 = require("../pnpm");
const utils_1 = require("../utils");
async function detectMonorepos(packageFiles) {
    await (0, pnpm_1.detectPnpmWorkspaces)(packageFiles);
    logger_1.logger.debug('Detecting workspaces');
    for (const p of packageFiles) {
        const { packageFile, npmrc, managerData = {}, skipInstalls } = p;
        const { npmLock, yarnZeroInstall, hasPackageManager, workspacesPackages, yarnLock, } = managerData;
        const packages = workspacesPackages;
        if (packages?.length) {
            const internalPackagePatterns = (is_1.default.array(packages) ? packages : [packages]).map((pattern) => (0, fs_1.getSiblingFileName)(packageFile, pattern));
            const internalPackageFiles = packageFiles.filter((sp) => (0, utils_1.matchesAnyPattern)((0, fs_1.getParentDir)(sp.packageFile), internalPackagePatterns));
            const internalPackageNames = internalPackageFiles
                .map((sp) => sp.managerData?.packageJsonName)
                .filter(Boolean);
            p.deps?.forEach((dep) => {
                if (is_1.default.string(dep.depName) &&
                    internalPackageNames.includes(dep.depName)) {
                    dep.isInternal = true;
                }
            });
            for (const subPackage of internalPackageFiles) {
                subPackage.managerData = subPackage.managerData ?? {};
                subPackage.managerData.yarnZeroInstall = yarnZeroInstall;
                subPackage.managerData.hasPackageManager = hasPackageManager;
                subPackage.managerData.yarnLock ??= yarnLock;
                subPackage.managerData.npmLock ??= npmLock;
                subPackage.skipInstalls = skipInstalls && subPackage.skipInstalls; // skip if both are true
                subPackage.managerData.workspacesPackages = workspacesPackages;
                subPackage.npmrc ??= npmrc;
                if (p.extractedConstraints) {
                    subPackage.extractedConstraints = {
                        ...p.extractedConstraints,
                        ...subPackage.extractedConstraints,
                    };
                }
                subPackage.deps?.forEach((dep) => {
                    if (internalPackageNames.includes(dep.depName)) {
                        dep.isInternal = true;
                    }
                });
            }
        }
    }
}
//# sourceMappingURL=monorepo.js.map