import type { z } from 'zod';
import type { PackageFile, PackageFileContent } from '../../types';
import type { PnpmCatalogsSchema } from '../schema';
import type { NpmManagerData } from '../types';
import type { LockFile, PnpmWorkspaceFile } from './types';
export declare function extractPnpmFilters(fileName: string): Promise<string[] | undefined>;
export declare function findPnpmWorkspace(packageFile: string): Promise<{
    lockFilePath: string;
    workspaceYamlPath: string;
} | null>;
export declare function detectPnpmWorkspaces(packageFiles: Partial<PackageFile<NpmManagerData>>[]): Promise<void>;
export declare function getPnpmLock(filePath: string): Promise<LockFile>;
export declare function tryParsePnpmWorkspaceYaml(content: string): {
    success: true;
    data: PnpmWorkspaceFile;
} | {
    success: false;
    data?: never;
};
type PnpmCatalogs = z.TypeOf<typeof PnpmCatalogsSchema>;
export declare function extractPnpmWorkspaceFile(catalogs: PnpmCatalogs, packageFile: string): Promise<PackageFileContent<NpmManagerData> | null>;
export {};
