"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNpmLock = getNpmLock;
const logger_1 = require("../../../../logger");
const fs_1 = require("../../../../util/fs");
const schema_1 = require("../schema");
async function getNpmLock(filePath) {
    const lockfileContent = await (0, fs_1.readLocalFile)(filePath, 'utf8');
    if (!lockfileContent) {
        logger_1.logger.debug({ filePath }, 'Npm: unable to read lockfile');
        return { lockedVersions: {} };
    }
    const parsedLockfile = schema_1.PackageLock.safeParse(lockfileContent);
    if (!parsedLockfile.success) {
        logger_1.logger.debug({ filePath, err: parsedLockfile.error }, 'Npm: unable to parse lockfile');
        return { lockedVersions: {} };
    }
    return parsedLockfile.data;
}
//# sourceMappingURL=npm.js.map