"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NixFlakeLock = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const InputType = zod_1.z.enum([
    'git',
    'github',
    'gitlab',
    'indirect',
    'path',
    'sourcehut',
    'tarball',
]);
const LockedInput = zod_1.z.object({
    ref: zod_1.z.string().optional(),
    rev: zod_1.z.string(),
    type: InputType,
});
const OriginalInput = zod_1.z.object({
    host: zod_1.z.string().optional(),
    owner: zod_1.z.string().optional(),
    repo: zod_1.z.string().optional(),
    ref: zod_1.z.string().optional(),
    type: InputType,
    url: zod_1.z.string().optional(),
});
const NixInput = zod_1.z.object({
    inputs: zod_1.z.record(zod_1.z.string(), zod_1.z.string().or(zod_1.z.array(zod_1.z.string()))).optional(),
    locked: LockedInput.optional(),
    original: OriginalInput.optional(),
});
exports.NixFlakeLock = schema_utils_1.Json.pipe(zod_1.z.object({
    nodes: zod_1.z.record(zod_1.z.string(), NixInput),
    version: zod_1.z.literal(7),
}));
//# sourceMappingURL=schema.js.map