"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.updateDependency = exports.bumpPackageVersion = exports.extractAllPackageFiles = void 0;
const docker_1 = require("../../datasource/docker");
const maven_1 = require("../../datasource/maven");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
var update_1 = require("./update");
Object.defineProperty(exports, "bumpPackageVersion", { enumerable: true, get: function () { return update_1.bumpPackageVersion; } });
Object.defineProperty(exports, "updateDependency", { enumerable: true, get: function () { return update_1.updateDependency; } });
exports.url = 'https://maven.apache.org';
exports.categories = ['java'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/(^|/|\\.)pom\\.xml$/',
        '/^(((\\.mvn)|(\\.m2))/)?settings\\.xml$/',
        '/(^|/)\\.mvn/extensions\\.xml$/',
    ],
};
exports.supportedDatasources = [maven_1.MavenDatasource.id, docker_1.DockerDatasource.id];
//# sourceMappingURL=index.js.map