"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateHelmEnvs = generateHelmEnvs;
const tslib_1 = require("tslib");
const semver_1 = tslib_1.__importDefault(require("semver"));
const upath_1 = tslib_1.__importDefault(require("upath"));
const fs_1 = require("../../../util/fs");
function generateHelmEnvs(config) {
    const cacheDir = (0, fs_1.privateCacheDir)();
    const envs = {
        // set cache and config files to a path in privateCacheDir to prevent file and credential leakage
        HELM_REGISTRY_CONFIG: upath_1.default.join(cacheDir, 'registry.json'),
        HELM_REPOSITORY_CONFIG: upath_1.default.join(cacheDir, 'repositories.yaml'),
        HELM_REPOSITORY_CACHE: upath_1.default.join(cacheDir, 'repositories'),
    };
    if (config.constraints?.helm &&
        !semver_1.default.intersects(config.constraints.helm, '>=3.8.0')) {
        envs.HELM_EXPERIMENTAL_OCI = '1';
    }
    return envs;
}
//# sourceMappingURL=common.js.map