"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../../../util/regex");
const maven_1 = require("../../datasource/maven");
const dependsOnRegex = (0, regex_1.regEx)(/@file\s*:\s*DependsOn\s*\(\s*(?<replaceString>"(?<groupId>.+):(?<artifactId>.+):(?<version>.+)")\s*\)/g);
const repositoryRegex = (0, regex_1.regEx)(/@file\s*:\s*Repository\s*\(\s*"(?<repositoryName>.+)"\s*\)/g);
function extractPackageFile(fileContent) {
    const registryUrls = [...fileContent.matchAll(repositoryRegex)]
        .map((match) => match.groups?.repositoryName)
        .filter(is_1.default.string);
    const matches = [...fileContent.matchAll(dependsOnRegex)]
        .map((m) => m.groups)
        .filter(is_1.default.truthy);
    const deps = [];
    for (const match of matches) {
        const dep = {
            currentValue: match.version,
            depName: `${match.groupId}:${match.artifactId}`,
            replaceString: match.replaceString,
            datasource: maven_1.MavenDatasource.id,
        };
        deps.push(dep);
    }
    if (deps.length === 0) {
        return null;
    }
    return {
        deps,
        ...(registryUrls.length && { registryUrls }),
    };
}
//# sourceMappingURL=extract.js.map