"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isOCIRegistry = isOCIRegistry;
exports.removeOCIPrefix = removeOCIPrefix;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
function isOCIRegistry(repository) {
    if (is_1.default.nullOrUndefined(repository)) {
        return false;
    }
    const repo = is_1.default.string(repository) ? repository : repository.repository;
    return repo.startsWith('oci://');
}
function removeOCIPrefix(repository) {
    if (isOCIRegistry(repository)) {
        return repository.replace('oci://', '');
    }
    return repository;
}
//# sourceMappingURL=oci.js.map