"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.supportsLockFileMaintenance = exports.bumpPackageVersion = exports.extractPackageFile = exports.updateArtifacts = void 0;
const docker_1 = require("../../datasource/docker");
const helm_1 = require("../../datasource/helm");
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var update_1 = require("./update");
Object.defineProperty(exports, "bumpPackageVersion", { enumerable: true, get: function () { return update_1.bumpPackageVersion; } });
exports.supportsLockFileMaintenance = true;
exports.displayName = 'Helm v3';
exports.url = 'https://helm.sh/docs';
exports.categories = ['helm', 'kubernetes'];
exports.defaultConfig = {
    registryAliases: {
        stable: 'https://charts.helm.sh/stable',
    },
    commitMessageTopic: 'helm chart {{depName}}',
    managerFilePatterns: ['/(^|/)Chart\\.ya?ml$/'],
};
exports.supportedDatasources = [docker_1.DockerDatasource.id, helm_1.HelmDatasource.id];
//# sourceMappingURL=index.js.map