"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.kustomizationsKeysUsed = kustomizationsKeysUsed;
exports.localChartHasKustomizationsYaml = localChartHasKustomizationsYaml;
exports.isOCIRegistry = isOCIRegistry;
exports.generateRegistryLoginCmd = generateRegistryLoginCmd;
const tslib_1 = require("tslib");
const upath_1 = tslib_1.__importDefault(require("upath"));
const fs_1 = require("../../../util/fs");
const hostRules = tslib_1.__importStar(require("../../../util/host-rules"));
const docker_1 = require("../../datasource/docker");
const common_1 = require("../helmv3/common");
/** Returns true if a helmfile release contains kustomize specific keys **/
function kustomizationsKeysUsed(release) {
    return (release.strategicMergePatches !== undefined ||
        release.jsonPatches !== undefined ||
        release.transformers !== undefined);
}
/** Returns true if a helmfile release uses a local chart with a kustomization.yaml file **/
// eslint-disable-next-line require-await
async function localChartHasKustomizationsYaml(release, helmFileYamlFileName) {
    const helmfileYamlParentDir = (0, fs_1.getParentDir)(helmFileYamlFileName) || '';
    return (0, fs_1.localPathExists)(upath_1.default.join(helmfileYamlParentDir, release.chart, 'kustomization.yaml'));
}
function isOCIRegistry(repository) {
    return repository.oci === true;
}
async function generateRegistryLoginCmd(repositoryName, repositoryBaseURL, repositoryHost) {
    const repositoryRule = {
        name: repositoryName,
        repository: repositoryHost,
        hostRule: hostRules.find({
            url: repositoryBaseURL,
            hostType: docker_1.DockerDatasource.id,
        }),
    };
    return await (0, common_1.generateLoginCmd)(repositoryRule);
}
//# sourceMappingURL=utils.js.map