"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockVersion = exports.Doc = exports.HelmRelease = exports.HelmRepository = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
exports.HelmRepository = zod_1.z.object({
    name: zod_1.z.string(),
    url: zod_1.z.string(),
    oci: zod_1.z.boolean().optional(),
});
exports.HelmRelease = zod_1.z.object({
    name: zod_1.z.string(),
    chart: zod_1.z.string(),
    version: zod_1.z
        .string()
        .or(zod_1.z.number())
        .optional()
        .nullable()
        .transform((version) => (version ? version.toString() : null)),
    strategicMergePatches: zod_1.z.unknown().optional(),
    jsonPatches: zod_1.z.unknown().optional(),
    transformers: zod_1.z.unknown().optional(),
});
exports.Doc = zod_1.z.object({
    releases: (0, schema_utils_1.LooseArray)(exports.HelmRelease).optional(),
    repositories: (0, schema_utils_1.LooseArray)(exports.HelmRepository).optional(),
});
exports.LockVersion = schema_utils_1.Yaml.pipe(zod_1.z.object({ version: zod_1.z.string() }).transform(({ version }) => version));
//# sourceMappingURL=schema.js.map