import { z } from 'zod';
export declare const HelmRepository: z.ZodObject<{
    name: z.ZodString;
    url: z.ZodString;
    oci: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    url: string;
    name: string;
    oci?: boolean | undefined;
}, {
    url: string;
    name: string;
    oci?: boolean | undefined;
}>;
export type HelmRepository = z.infer<typeof HelmRepository>;
export declare const HelmRelease: z.ZodObject<{
    name: z.ZodString;
    chart: z.ZodString;
    version: z.ZodEffects<z.ZodNullable<z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>>, string | null, string | number | null | undefined>;
    strategicMergePatches: z.ZodOptional<z.ZodUnknown>;
    jsonPatches: z.ZodOptional<z.ZodUnknown>;
    transformers: z.ZodOptional<z.ZodUnknown>;
}, "strip", z.ZodTypeAny, {
    name: string;
    version: string | null;
    chart: string;
    strategicMergePatches?: unknown;
    jsonPatches?: unknown;
    transformers?: unknown;
}, {
    name: string;
    chart: string;
    version?: string | number | null | undefined;
    strategicMergePatches?: unknown;
    jsonPatches?: unknown;
    transformers?: unknown;
}>;
export type HelmRelease = z.infer<typeof HelmRelease>;
export declare const Doc: z.ZodObject<{
    releases: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        name: string;
        version: string | null;
        chart: string;
        strategicMergePatches?: unknown;
        jsonPatches?: unknown;
        transformers?: unknown;
    }[], any[]>>;
    repositories: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        url: string;
        name: string;
        oci?: boolean | undefined;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    releases?: {
        name: string;
        version: string | null;
        chart: string;
        strategicMergePatches?: unknown;
        jsonPatches?: unknown;
        transformers?: unknown;
    }[] | undefined;
    repositories?: {
        url: string;
        name: string;
        oci?: boolean | undefined;
    }[] | undefined;
}, {
    releases?: any[] | undefined;
    repositories?: any[] | undefined;
}>;
export type Doc = z.infer<typeof Doc>;
export declare const LockVersion: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodEffects<z.ZodObject<{
    version: z.ZodString;
}, "strip", z.ZodTypeAny, {
    version: string;
}, {
    version: string;
}>, string, {
    version: string;
}>>;
export type LockVersion = z.infer<typeof LockVersion>;
