import type { ExtractConfig, PackageDependency, PackageFileContent } from '../types';
import type { HelmDockerImageDependency } from './types';
/**
 * Recursively find all supported dependencies in the yaml object.
 *
 * @param parsedContent
 */
export declare function findDependencies(parsedContent: Record<string, unknown> | HelmDockerImageDependency, registryAliases: Record<string, string> | undefined): PackageDependency[];
export declare function findDependenciesInternal(parsedContent: Record<string, unknown> | HelmDockerImageDependency, packageDependencies: PackageDependency[], registryAliases: Record<string, string> | undefined): PackageDependency[];
export declare function extractPackageFile(content: string, packageFile: string, config: ExtractConfig): PackageFileContent | null;
