"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const helm_1 = require("../../datasource/helm");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'Helm v2 Chart Dependencies';
exports.url = 'https://v2.helm.sh/docs/developing_charts/#chart-dependencies';
exports.categories = ['helm', 'kubernetes'];
exports.defaultConfig = {
    registryAliases: {
        stable: 'https://charts.helm.sh/stable',
    },
    commitMessageTopic: 'helm chart {{depName}}',
    managerFilePatterns: ['/(^|/)requirements\\.ya?ml$/'],
};
exports.supportedDatasources = [helm_1.HelmDatasource.id];
//# sourceMappingURL=index.js.map