"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const yaml_1 = require("../../../util/yaml");
const helm_1 = require("../../datasource/helm");
function extractPackageFile(content, packageFile, config) {
    let deps = [];
    // TODO: fix type
    let doc;
    try {
        doc = (0, yaml_1.parseSingleYaml)(content); // TODO #9610
    }
    catch {
        logger_1.logger.debug({ packageFile }, `Failed to parse helm requirements.yaml`);
        return null;
    }
    if (!(doc && is_1.default.array(doc.dependencies))) {
        logger_1.logger.debug({ packageFile }, `requirements.yaml has no dependencies`);
        return null;
    }
    deps = doc.dependencies.map((dep) => {
        let currentValue; // Remove when #9610 has been implemented
        switch (typeof dep.version) {
            case 'number':
                currentValue = String(dep.version);
                break;
            case 'string':
                currentValue = dep.version;
        }
        const res = {
            depName: dep.name,
            currentValue,
        };
        if (!res.depName) {
            res.skipReason = 'invalid-name';
            return res;
        }
        if (!res.currentValue) {
            res.skipReason = 'invalid-version';
            return res;
        }
        if (!dep.repository) {
            res.skipReason = 'no-repository';
            return res;
        }
        res.registryUrls = [dep.repository];
        if (dep.repository.startsWith('@') || dep.repository.startsWith('alias:')) {
            const repoWithPrefixRemoved = dep.repository.slice(dep.repository[0] === '@' ? 1 : 6);
            const alias = config.registryAliases?.[repoWithPrefixRemoved];
            if (alias) {
                res.registryUrls = [alias];
                return res;
            }
            res.skipReason = 'placeholder-url';
        }
        else {
            try {
                const url = new URL(dep.repository);
                if (url.protocol === 'file:') {
                    res.skipReason = 'local-dependency';
                }
            }
            catch (err) {
                logger_1.logger.debug({ err, packageFile, url: dep.repository }, 'Error parsing url');
                res.skipReason = 'invalid-url';
            }
        }
        return res;
    });
    const res = {
        deps,
        datasource: helm_1.HelmDatasource.id,
    };
    return res;
}
//# sourceMappingURL=extract.js.map