export declare function countPackageNameLength(input: string): number | null;
export interface CabalDependency {
    packageName: string;
    currentValue: string;
    replaceString: string;
}
/**
 * Find extents of field contents
 *
 * @param {number} indent -
 *    Indention level maintained within the block.
 *    Any indention lower than this means it's outside the field.
 *    Lines with this level or more are included in the field.
 * @returns {number}
 *    Index just after the end of the block.
 *    Note that it may be after the end of the string.
 */
export declare function findExtents(indent: number, content: string): number;
/**
 * Find indention level of build-depends
 *
 * @param {number} match -
 *   Search starts at this index, and proceeds backwards.
 * @returns {number}
 *   Number of indention levels found before 'match'.
 */
export declare function countPrecedingIndentation(content: string, match: number): number;
/**
 * Find one 'build-depends' field name usage and its field value
 *
 * @returns {{buildDependsContent: string, lengthProcessed: number}}
 *   buildDependsContent:
 *     the contents of the field, excluding the field name and the colon,
 *     and any comments within
 *
 *   lengthProcessed:
 *     points to after the end of the field. Note that the field does _not_
 *     necessarily start at `content.length - lengthProcessed`.
 *
 *   Returns null if no 'build-depends' field is found.
 */
export declare function findDepends(content: string): {
    buildDependsContent: string;
    lengthProcessed: number;
} | null;
/**
 * Split a cabal single dependency into its constituent parts.
 * The first part is the package name, an optional second part contains
 * the version constraint.
 *
 * For example 'base == 3.2' would be split into 'base' and ' == 3.2'.
 *
 * @returns {{name: string, range: string}}
 *   Null if the trimmed string doesn't begin with a package name.
 */
export declare function splitSingleDependency(input: string): {
    name: string;
    range: string;
} | null;
export declare function extractNamesAndRanges(content: string): CabalDependency[];
