"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qVersionCatalogs = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const common_1 = require("./common");
const handlers_1 = require("./handlers");
const qVersionCatalogVersion = good_enough_parser_1.query
    .op('.')
    .alt(
// library("kotlin-reflect", "org.jetbrains.kotlin", "kotlin-reflect").versionRef("kotlin")
good_enough_parser_1.query.sym('versionRef').tree({
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(common_1.qStringValueAsSymbol).end(),
}), 
// library("android-gradle", "com.android.tools.build", "gradle").version("${agp}")
good_enough_parser_1.query.sym('version').tree({
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(common_1.qValueMatcher).end(),
}))
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'version'));
// library("foo.bar", "foo", "bar")
const qVersionCatalogDependencies = good_enough_parser_1.query
    .sym('library', common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'methodName'))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .join(common_1.qStringValue)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'alias'))
        .op(',')
        .join(common_1.qGroupId)
        .op(',')
        .join(common_1.qArtifactId)
        .end(),
})
    .opt(qVersionCatalogVersion)
    .handler(handlers_1.handleLibraryDep)
    .handler(common_1.cleanupTempVars);
// plugin("foo.bar", "foo:bar")
const qVersionCatalogPlugins = good_enough_parser_1.query
    .sym('plugin', common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'methodName'))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .join(common_1.qStringValue)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'alias'))
        .op(',')
        .alt(common_1.qStringValue)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'pluginName'))
        .end(),
})
    .join(qVersionCatalogVersion)
    .handler(handlers_1.handlePlugin)
    .handler(common_1.cleanupTempVars);
// alias("foo.bar").to("foo", "bar").version("1.2.3")
const qVersionCatalogAliasDependencies = good_enough_parser_1.query
    .sym('alias')
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query
        .begin()
        .join(common_1.qStringValue)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'alias'))
        .end(),
})
    .op('.')
    .sym('to')
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(common_1.qGroupId).op(',').join(common_1.qArtifactId).end(),
})
    .opt(qVersionCatalogVersion)
    .handler(handlers_1.handleLibraryDep)
    .handler(common_1.cleanupTempVars);
exports.qVersionCatalogs = good_enough_parser_1.query.alt(qVersionCatalogDependencies, qVersionCatalogPlugins, qVersionCatalogAliasDependencies);
//# sourceMappingURL=version-catalogs.js.map